<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Link\Scripts
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register frontend scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_link_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Scripts
    wp_register_script( 'automatorwp-link-js', AUTOMATORWP_LINK_URL . 'assets/js/automatorwp-link' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_LINK_VER, true );

}
add_action( 'init', 'automatorwp_link_register_scripts' );

/**
 * Enqueue frontend scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_link_enqueue_scripts( $hook = null ) {

    // Scripts
    wp_localize_script( 'automatorwp-link-js', 'automatorwp_link', array(
        'ajaxurl' => esc_url( admin_url( 'admin-ajax.php', 'relative' ) ),
        'nonce' => wp_create_nonce( 'automatorwp_link' )
    ) );

    wp_enqueue_script( 'automatorwp-link-js' );

}
add_action( 'wp_enqueue_scripts', 'automatorwp_link_enqueue_scripts', 100 );